package arrayclasses;

public class ClassList {
   private static final int DEFAULT_SIZE = 5;
   private String courseTitle;
   private String discipline;
   private String semester;
   private String instructor;
   private String courseID;
   private StudentGrade[] studentList;
   private int classSize;

   public ClassList(String title, String disc,
                    String sem, String ins, String ID) {
      courseTitle = title;
      discipline = disc;
      semester = sem;
      instructor = ins;
      courseID = ID;
      studentList = new StudentGrade[DEFAULT_SIZE];
      classSize = 0;
   }

   public void addStudent(StudentGrade s) { // don't forget duplicates
      if (studentList.length == classSize)
         resize();
      studentList[classSize] = s;
      classSize++;
   }

   public String getCourseID() {
      return courseID;
   }

   public String getDiscipline() {
      return discipline;
   }

   public double getGrade(String ID) {
      int position = find(ID);
      if (position == -1)
         return -1;
      return studentList[position].getGrade();
   }

   public String getInstructor() {
      return instructor;
   }

   public String getSemester() {
      return semester;
   }

   public StudentGrade getStudent(String ID) {
      int position = find(ID);
      if (position == -1)
         return null;
      return studentList[position];

   }

   public String getTitle() {
      return courseTitle;
   }

   public void remove(String ID) {
      int position = find(ID);
      if (position == -1)
         return;
      classSize--;
      studentList[position] = studentList[classSize];
   }

   public void setGrade(String ID, double grade) {
      int position = find(ID);
      if (position == -1)
         return;
      studentList[position].setGrade(grade);
   }

   public String toString() {
      StringBuffer buf = new StringBuffer(getClass().getName() + "[title=" +
                                          courseTitle + ",discipline=" +
                                          discipline +
                                          ",semester=" + semester +
                                          ",courseID=" +
                                          courseID + ",instructor=" +
                                          instructor + "]");
      for (int i = 0; i < classSize; i++)
         buf.append("\n" + studentList[i]);
      return buf.toString();
   }

   private int find(String ID) {
      for (int i = 0; i < classSize; i++)
         if (ID.equals(studentList[i].getStudentID()))
            return i;
      return -1;
   }

   private void resize() {
      StudentGrade[] temp = new StudentGrade[2 * studentList.length];
      for (int i = 0; i < studentList.length; i++)
         temp[i] = studentList[i];
      studentList = temp;
   }
}
