package sorts;

import java.util.*;

public class QuadraticSorts {
//----------------------------------------------
  public static void selectionSort(Comparable[] list) {
    for (int index = 0; index < list.length - 1; index++) {
      int min = findMinPosition(list, index);
      Comparable temp = list[min];
      list[min] = list[index];
      list[index] = temp;
    }
  }

  public static int findMinPosition(Comparable[] list, int start) {
    int min = start;
    for (int scan = start + 1; scan < list.length; scan++)
      if (list[min].compareTo(list[scan]) > 0)
        min = scan;
    return min;
  }
//---------------------------------------------
  public static void selectionSort(int[] list) {
    for (int index = 0; index < list.length - 1; index++) {
      int min = findMinPosition(list, index);
      int temp = list[min];
      list[min] = list[index];
      list[index] = temp;
    }
  }

  public static int findMinPosition(int[] list, int start) {
    int min = start;
    for (int scan = start + 1; scan < list.length; scan++)
      if (list[min] > list[scan])
        min = scan;
    return min;
  }
//---------------------------------------------
  public static void insertionSort(Comparable[] list) {
    for (int index = 1; index < list.length; index++) {
      insertItem(list, index);
    }
  }

  public static void insertItem(Comparable[] list, int index) {
    Comparable key = list[index];
    int position = index;

    // shift larger values to the right
    while (position > 0 && key.compareTo(list[position - 1]) < 0) {
      list[position] = list[position - 1];
      position--;
    }
    list[position] = key;
  }


// -----------------------------------------------
    public static void insertionSort(int[] list) {
      for (int index = 1; index < list.length; index++) {
        insertItem(list, index);
      }
    }

    public static void insertItem(int[] list, int index) {
      int key = list[index];
      int position = index;

      // shift larger values to the right
      while (position > 0 && (key < list[position - 1])) {
        list[position] = list[position - 1];
        position--;
      }
      list[position] = key;
    }
//--------------------------------------

    public static void printArray(int[] array) {
      for (int i=0;i<array.length;i++)
        System.out.print(array[i] + " ");
      System.out.println();
    }

// ---------------------
    public static int[] makeArray(int n) {
      Random rand = new Random();
      int[] array = new int[n];
      for (int i=0;i<n;i++)
        array[i] = rand.nextInt(10*n);
      return array;
    }

//------------------------

    public static int[] cloneArray(int[] array) {
      int[] newArray = new int[array.length];
      for (int i=0;i<array.length;i++)
        newArray[i] = array[i];
      return newArray;
    }
}
