package sorts;

import java.text.*;
import java.util.*;

public class SortTester {

  private static final double BILLION = 1000000000.0;

  public static void main(String[] args) {

    long startTime, endTime;

    int[] test1;
    int[] test2;
    int[] test3;
    int n;
    double creationTime;
    double selectionSortTime;
    double insertionSortTime;
    double javaSortTime;
    n = 100;
    System.out.println("       n   Selection  Insertion       Java   Creation");
    for (int i = 0; i <= 15; i++) {

      startTime = System.nanoTime();
      test1 = QuadraticSorts.makeArray(n);
      test2 = QuadraticSorts.cloneArray(test1);
      test3 = QuadraticSorts.cloneArray(test1);
      endTime = System.nanoTime();
      creationTime = (endTime - startTime) / BILLION;
      if (n < 200000) {
        startTime = System.nanoTime();
        QuadraticSorts.selectionSort(test1);
        endTime = System.nanoTime();
        selectionSortTime = (endTime - startTime) / BILLION;
        startTime = System.nanoTime();
        QuadraticSorts.insertionSort(test2);
        endTime = System.nanoTime();
        insertionSortTime = (endTime - startTime) / BILLION;
      }
      else {
        selectionSortTime = -1;
        insertionSortTime = -1;
      }
      startTime = System.nanoTime();
      Arrays.sort(test3);
      endTime = System.nanoTime();
      javaSortTime = (endTime - startTime) / BILLION;
      System.out.println(padLeft(n + " ", 9) + " " +
                         formatDouble(selectionSortTime, 10) + " " +
                         formatDouble(insertionSortTime, 10) + " " +
                         formatDouble(javaSortTime, 10) + " " +
                         formatDouble(creationTime, 10));
      n = 2 * n;
    }
  }

  public static String padLeft(String s, int n) {
    while (s.length() < n)
      s = " " + s;
    return s;
  }

  public static String formatDouble(double val, int n) {
    String s;
    DecimalFormat df = new DecimalFormat("0.0000");
    if (val < 0)
      s = "";
    else
      s = df.format(val);
    while (s.length() < n)
      s = " " + s;
    return s;
  }

}
