package tictactoegui;

import javax.swing.*;

public class UserGUI
    implements UserInterface {

  private GameInterface game;
  private char id;

  public UserGUI(GameInterface game) {
    this.game = game;
    id = game.joinGame(this);
    System.out.println("This is user "+id);
    makeFrame();
  }

  private void makeFrame() {
    JFrame window = new JFrame("Tic Tac Toe");
   window.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
   JPanel mainPanel = new JPanel();
   setupMainPanel(mainPanel);
   window.getContentPane().add(mainPanel); // component added to content pane
   window.pack(); // sets the frame's size to accommodate its components
   window.setVisible(true); // displays the frame
}

 private void setupMainPanel(JPanel mainPanel) {
   System.out.println("Setting up main panel for user "+id);
 }


  public void setDone(char c) {}

  public void requestMove() {
     System.out.println("User "+id+" has been requested to make a move");
  }

  public void setBoard(char[][] board) {
    System.out.print("User "+id+" got board: ");
    for (int i=0;i<board.length;i++)
      for (int j=0;j<board[i].length;j++)
        System.out.print(board[i][j]);
    System.out.println();
  }

}
