package tictactoegui;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class UserGUI
    implements UserInterface, ActionListener {

  private GameInterface game;
  private char id;
  private JLabel topLabel;
  private JLabel bottomLabel;
  private int boardsize;
  private JButton[][] buttons;

  public UserGUI(GameInterface game) {
    this.game = game;
    boardsize = game.getBoardSize();
    id = game.joinGame(this);
    System.out.println("This is user "+id);
    makeFrame();
    topLabel.setText("User: "+id);
  }

  private void makeFrame() {
    JFrame window = new JFrame("Tic Tac Toe");
   window.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
   JPanel mainPanel = new JPanel();
   setupMainPanel(mainPanel);
   window.getContentPane().add(mainPanel); // component added to content pane
   window.pack(); // sets the frame's size to accommodate its components
   window.setVisible(true); // displays the frame
}

 private void setupMainPanel(JPanel mainPanel) {
   System.out.println("Setting up main panel for user "+id);
   mainPanel.setLayout(new BorderLayout());
   topLabel = new JLabel("This is the top");
   bottomLabel = new JLabel("This is the bottom");
   mainPanel.add(topLabel,BorderLayout.NORTH);
   mainPanel.add(bottomLabel,BorderLayout.SOUTH);
   JPanel centerPanel = new JPanel();
   centerPanel.setLayout(new GridLayout(boardsize,boardsize));
   buttons = new JButton[boardsize][boardsize];
   for (int i=0;i<boardsize;i++)
     for (int j=0;j<boardsize;j++) {
       buttons[i][j] = new JButton(" ");
       buttons[i][j].addActionListener(this);
       centerPanel.add(buttons[i][j]);
     }
   mainPanel.add(centerPanel,BorderLayout.CENTER);
 }


  public void setDone(char c) {}

  public void requestMove() {
     System.out.println("User "+id+" has been requested to make a move");
  }

  public void setBoard(char[][] board) {
    System.out.print("User "+id+" got board: ");
    for (int i=0;i<board.length;i++)
      for (int j=0;j<board[i].length;j++)
        System.out.print(board[i][j]);
    System.out.println();
  }

  public void actionPerformed(ActionEvent e) {
    Object source = e.getSource();
    System.out.println("A button was pushed");
    bottomLabel.setText("A button was pushed");
    for (int i=0;i<boardsize;i++)
     for (int j=0;j<boardsize;j++) {
       if (source == buttons[i][j])
         bottomLabel.setText("puhed buttton as "+i+" "+j);
     }
  }

}
