package tictactoegui;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class UserGUI
    implements UserInterface, ActionListener, MouseListener, KeyListener {

  private static int BOX_SIZE = 100;
  private GameInterface game;
  private char id;
  private JLabel topLabel;
  private JLabel bottomLabel;
  private int boardsize;
  private JButton[][] buttons;
  private String cheatString = "";

  public UserGUI(GameInterface game) {
    this.game = game;
    boardsize = game.getBoardSize();
    id = game.joinGame(this);
//    System.out.println("This is user "+id);
    makeFrame();
    topLabel.setText("User: " + id);
  }

  private void makeFrame() {
    JFrame window = new JFrame("Tic Tac Toe");
    window.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    JPanel mainPanel = new JPanel();
    setupMainPanel(mainPanel);
    window.getContentPane().add(mainPanel); // component added to content pane
    window.pack(); // sets the frame's size to accommodate its components
    if (id != 'X')
      window.setLocation(BOX_SIZE * (boardsize + 1), 0);
    window.setVisible(true); // displays the frame
  }

  private void setupMainPanel(JPanel mainPanel) {
//   System.out.println("Setting up main panel for user "+id);
    mainPanel.setLayout(new BorderLayout());
    topLabel = new JLabel("This is the top", JLabel.CENTER);
    Font f = new Font("Serif", Font.PLAIN, 20);
    topLabel.setOpaque(true);
    topLabel.setBackground(Color.cyan);
    topLabel.setForeground(Color.blue);
    topLabel.setFont(f);
    topLabel.addMouseListener(this);
    topLabel.addKeyListener(this);

    bottomLabel = new JLabel("This is the bottom");
    mainPanel.add(topLabel, BorderLayout.NORTH);
    mainPanel.add(bottomLabel, BorderLayout.SOUTH);
    JPanel centerPanel = new JPanel();
    centerPanel.setLayout(new GridLayout(boardsize, boardsize));
    buttons = new JButton[boardsize][boardsize];
    f = new Font("Serif", Font.BOLD, 40);
    for (int i = 0; i < boardsize; i++)
      for (int j = 0; j < boardsize; j++) {
        buttons[i][j] = new JButton(" ");
        buttons[i][j].setFont(f);
        buttons[i][j].addActionListener(this);
        buttons[i][j].setPreferredSize(new Dimension(BOX_SIZE, BOX_SIZE));
        centerPanel.add(buttons[i][j]);
      }
    mainPanel.add(centerPanel, BorderLayout.CENTER);
  }

  public void setDone(char c) {
    if (c == Game.DRAW)
      topLabel.setText("User: " + id + "   Game is a draw!");
    else if (c == id)
      topLabel.setText("User: " + id + "   You Won!");
    else
      topLabel.setText("User: " + id + "   You Lost!");
  }

  public void requestMove() {
//     System.out.println("User "+id+" has been requested to make a move");
    bottomLabel.setText("Please make a move");
  }

  public void setBoard(char[][] board) {
//    System.out.print("User "+id+" got board: ");
    for (int i = 0; i < board.length; i++)
      for (int j = 0; j < board[i].length; j++) {
        buttons[i][j].setText("" + board[i][j]);
//        System.out.print(board[i][j]);
      }
//    System.out.println();
  }

  public void actionPerformed(ActionEvent e) {
    Object source = e.getSource();
//    System.out.println("A button was pushed");
    bottomLabel.setText(" Move Made ");
    for (int i = 0; i < boardsize; i++)
      for (int j = 0; j < boardsize; j++) {
        if (source == buttons[i][j]) {
          if (!game.move(i, j, this))
            bottomLabel.setText(" Invalid move attempted");
        }
      }
  }

  public void mouseClicked(MouseEvent e) {}

  public void mouseEntered(MouseEvent e) {
    System.out.println("Mouse entered top label");
    topLabel.requestFocus();
  }

  public void mouseExited(MouseEvent e) {}

  public void mousePressed(MouseEvent e) {}

  public void mouseReleased(MouseEvent e) {}

  public void keyPressed(KeyEvent e) {}

  public void keyReleased(KeyEvent e) {}

  public void keyTyped(KeyEvent e) {
    char c;
    c = e.getKeyChar();
    if (c == '\n') {
      handleCheatCode();
      cheatString = "";
    }
    else
      cheatString = cheatString + c;
    System.out.println("key typed in top label: " + c);

  }

  private void handleCheatCode() {
    StringTokenizer stk;
    int r1, c1, r2, c2;
    System.out.println("Got cheat code "+cheatString);
    stk = new StringTokenizer(cheatString);
    if (stk.countTokens() != 5)
      return;
    if (!stk.nextToken().equals("cheat"))
      return;
    System.out.println("Got a good cheat code");
    r1 = convertToIndex(stk.nextToken());
      c1 = convertToIndex(stk.nextToken());
        r2 = convertToIndex(stk.nextToken());
          c2 = convertToIndex(stk.nextToken());
    interchange(r1,c1,r2,c2);
  }

  private void interchange(int r1, int c1, int r2, int c2) {

  }

  private int convertToIndex(String s) {
    int n;
    n = Integer.parseInt(s);
    return n;
  }

}
