package tictactoegui;

import java.io.*;
import java.util.*;

public class Game
    implements GameInterface {

  private static char NOWINNER = ' ';
  private static char EMPTY = ' ';
  public static char DRAW = 'D';
  private static char XCHAR = 'X';
  private static char OCHAR = 'O';
  private int boardsize;
  private UserInterface userX = null;
  private UserInterface userO = null;
  private UserInterface nextUserToMove = null;
  private char nextCharToMove = EMPTY;
  private char[][] board;

  private char winner = NOWINNER;
  private int numberMoves = 0;
  private PrintWriter out;
  String filename = "gamelog.txt";

  public Game(int boardsize) {
    System.out.println("This program was written by S. Robbins and his CS 1713 class on November 17, 2006");
    this.boardsize = boardsize;
    board = new char[boardsize][boardsize];
    for (int i = 0; i < boardsize; i++)
      for (int j = 0; j < boardsize; j++)
        board[i][j] = EMPTY;
    String s = getOldLog(filename);
    try {
      out = new PrintWriter(new PrintWriter(filename), true);
    }
    catch (FileNotFoundException e) {
      System.out.println("Could not create file " + filename);
    }
    if (s.length() > 0)
      out.println(s);
    log("Game Started");
  }

  private void log(String s) {
    out.println(new Date() + ": " + s);
  }

  private String getOldLog(String filename) {
    Scanner scan;
    String s = "";
    String line;
    try {
      scan = new Scanner(new FileInputStream(filename));
      while (scan.hasNextLine()) {
        line = scan.nextLine();
        s = s + line + "\n";
      }
    }
    catch (FileNotFoundException e) {
      System.out.println("File not found exception for " + filename);
      return "";
    }
    return s;
  }

  public int getBoardSize() {
    return boardsize;
  }

  private String moveString(int row, int col) {
    return "(" + row + "," + col + ")";
  }

  public boolean move(int row, int col, UserInterface user) {
    if ( (row < 0) || (row >= boardsize)) {
      log("Invalid row in move: " + moveString(row, col));
      return false;
    }
    if ( (col < 0) || (col >= boardsize)) {
      log("Invalid column in move: " + moveString(row, col));
      return false;
    }
    if (user != nextUserToMove) {
      log("Move attempt " + moveString(row, col) +
          " by wrong user, correct user is " + nextCharToMove);
      return false;
    }
    if (winner != NOWINNER)
      return false;
    if (board[row][col] == EMPTY) {
      board[row][col] = nextCharToMove;
      setBoard();
      log("Valid move " + moveString(row, col) + " made by " + nextCharToMove);
      if (nextCharToMove == XCHAR) {
        nextCharToMove = OCHAR;
        nextUserToMove = userO;
      }
      else {
        nextCharToMove = XCHAR;
        nextUserToMove = userX;
      }
      numberMoves++;
      setWinner();
      if (winner != NOWINNER) {
        userX.setDone(winner);
        userO.setDone(winner);
        if (winner == DRAW)
          log("Game is a draw!");
        else
          log("Winner is " + winner);
      }
      else
        nextUserToMove.requestMove();
      return true;
    }
    return false;
  }

  public void startGame() {
    setBoard();
    userX.requestMove();
  }

  private void setBoard() {
    char[][] copy = new char[boardsize][boardsize];
    for (int i = 0; i < boardsize; i++)
      for (int j = 0; j < boardsize; j++)
        copy[i][j] = board[i][j];
    userX.setBoard(board);
    userO.setBoard(copy);
  }

  public char joinGame(UserInterface user) {
    if (userX == null) {
      userX = user;
      nextUserToMove = userX;
      nextCharToMove = XCHAR;
      return 'X';
    }
    else if (userO == null) {
      userO = user;
      return 'O';
    }
    return ' ';
  }

  private boolean backDiagonalWinner() {
    char test = board[0][boardsize - 1];
    if (test == EMPTY)
      return false;
    for (int i = 1; i < boardsize; i++)
      if (test != board[i][boardsize - 1 - i])
        return false;
    winner = test;
    return true;
  }

  private boolean columnWinner(int col) {
    char test = board[0][col];
    if (test == EMPTY)
      return false;
    for (int i = 1; i < boardsize; i++)
      if (test != board[i][col])
        return false;
    winner = test;
    return true;
  }

  private boolean forwardDiagonalWinner() {
    char test = board[0][0];
    if (test == EMPTY)
      return false;
    for (int i = 1; i < boardsize; i++)
      if (test != board[i][i])
        return false;
    winner = test;
    return true;
  }

  private boolean rowWinner(int row) {
    char test = board[row][0];
    if (test == EMPTY)
      return false;
    for (int i = 1; i < boardsize; i++)
      if (test != board[row][i])
        return false;
    winner = test;
    return true;
  }

  private void setWinner() {
    if (winner != NOWINNER)
      return;
    if (forwardDiagonalWinner() || backDiagonalWinner())
      return;
    for (int i = 0; i < boardsize; i++)
      if (rowWinner(i) || columnWinner(i))
        return;
    if (numberMoves == boardsize * boardsize)
      winner = DRAW;
  }

}
