package circle;

import java.text.*;

public class CircleTester1 {
  public static void main(String[] args) {
    Circle c1;
    Circle c2;
    double area1 = Math.PI * 10 * 10;
    double cir1 = 2 * Math.PI * 10;
    double area2 = Math.PI * 5 * 5;
    double cir2 = 2 * Math.PI * 5;
    System.out.println("This tester was written by S. Robbins");
    System.out.println();
    System.out.println(getTableHeading());

    c1 = new Circle(10, 0, 0);

    c2 = new Circle(10, 0, 0);
    showCircleInfo("equal", c1, c2, area1, cir1, area1, cir1,
                   true, true, false, false, area1);

    c2 = new Circle(5, 20, 20);
    showCircleInfo("far apart", c1, c2, area1, cir1, area2, cir2,
                   false, false, false, false, 0);

    c2 = new Circle(5, 0, 15);
    showCircleInfo("tangent outside", c1, c2, area1, cir1, area2, cir2,
                   false, true, false, false, 0);

    c2 = new Circle(5, 0, 12);
    showCircleInfo("intersect a little", c1, c2, area1, cir1, area2, cir2,
                   false, true, false, false, 17.009800104552426);

    c2 = new Circle(5, 0, 6);
    showCircleInfo("intersect a lot", c1, c2, area1, cir1, area2,
                   cir2,
                   false, true, false, false, 73.1375661373978);

    c2 = new Circle(5, 0, 5.00);
    showCircleInfo("tangent inside", c1, c2, area1, cir1, area2, cir2,
                   false, true, false, false, area2);

    c2 = new Circle(5, 0, 4);
    showCircleInfo("inside", c1, c2, area1, cir1, area2, cir2,
                   false, false, true, false, area2);

    c2 = new Circle(5, 0, 0);
    showCircleInfo("concentric", c1, c2, area1, cir1, area2, cir2,
                   false, false, true, false, area2);

    c1 = new Circle(10, 3, 7);
    c2 = new Circle(5, 13, 2);
    showCircleInfo("nonstandard position", c1, c2, area1, cir1, area2, cir2,
                   false, true, false, false, 24.043478844932856);
  }

  private static String getTableHeading() {
    return
        "type                    r1    x1    y1    area 1   circum 1     " +
        "r2    x2    y2    area 2   circum 2 equals  inter inside     " +
        "area of intersection";
  }

  private static void showCircleInfo(String s, Circle c1,
                                     Circle c2, double area1,
                                     double cir1, double area2,
                                     double cir2,
                                     boolean equalsFlag,
                                     boolean intersectsFlag,
                                     boolean inside1Flag,
                                     boolean inside2Flag,
                                     double intersectArea) {
/*
    // The following is used with a correct Circle class to determine the
    // correct answers which have been hard coded into this tester.
    System.out.println(s);
    System.out.println("Circle 1: " + c1);
    System.out.println("Circle 2: " + c2);
    System.out.println("Areas are " + c1.getArea() + " and " + c2.getArea());
    System.out.println("Circumferences are " + c1.getCircumference() + " and " +
                       c2.getCircumference());
    System.out.println("c1.equals(c2) is " + c1.equals(c2));
    System.out.println("c2.equals(12) is " + c2.equals(c1));
    System.out.println("c1.inside(c2) is " + c1.inside(c2));
    System.out.println("c2.inside(c1) is " + c2.inside(c1));
    System.out.println("c1.intersects(c2) is " + c1.intersects(c2));
    System.out.println("c2.intersects(c1) is " + c2.intersects(c1));
    System.out.println("c1.areaOfIntersection(c2) is " +
                       c1.areaOfIntersection(c2));
    System.out.println("c2.areaOfIntersection(c1) is " +
                       c2.areaOfIntersection(c1));
    System.out.println();
*/

    System.out.print(leftJustify(s, 20));
    System.out.print(format(c1.getRadius(), 2, 6));
    System.out.print(format(c1.getX(), 2, 6));
    System.out.print(format(c1.getY(), 2, 6));
    System.out.print(format(c1.getArea(), 3, 10));
    System.out.print(checkValue(c1.getArea(), area1));
    System.out.print(format(c1.getCircumference(), 3, 10));
    System.out.print(checkValue(c1.getCircumference(), cir1));
    System.out.print(format(c2.getRadius(), 2, 6));
    System.out.print(format(c2.getX(), 2, 6));
    System.out.print(format(c2.getY(), 2, 6));
    System.out.print(format(c2.getArea(), 3, 10));
    System.out.print(checkValue(c2.getArea(), area2));
    System.out.print(format(c2.getCircumference(), 3, 10));
    System.out.print(checkValue(c2.getCircumference(), cir2));
    System.out.print("    " + tf(c1.equals(c2)) +
                     tf(c2.equals(c1)));
    System.out.print(checkBoolean(c1.equals(c2), c2.equals(c1),
                                  equalsFlag));
    System.out.print("    " + tf(c1.intersects(c2)) +
                     tf(c2.intersects(c1)));
    System.out.print(checkBoolean(c1.intersects(c2),
                                  c2.intersects(c1),
                                  intersectsFlag));
    System.out.print("    " + tf(c1.inside(c2)) +
                     tf(c2.inside(c1)));
    System.out.print(checkBoolean(c1.inside(c2), inside1Flag,
                                  c2.inside(c1), inside2Flag));
    System.out.print(format(c1.areaOfIntersection(c2), 5, 12));
    System.out.print(checkValue(c1.areaOfIntersection(c2),
                                intersectArea));
    System.out.print(format(c2.areaOfIntersection(c1), 5, 12));
    System.out.print(checkValue(c2.areaOfIntersection(c1),
                                intersectArea));
    System.out.println();

  }

  private static String checkValue(double v1, double v2) {
    if (Math.abs(v1 - v2) < 0.00001)
      return " ";
    return "*";
  }

  private static String checkBoolean(boolean flag1, boolean flag2,
                                     boolean flag3) {
    if (flag1 == flag2 && flag2 == flag3)
      return " ";
    return "*";
  }

  private static String checkBoolean(boolean flag1, boolean flag2,
                                     boolean flag3, boolean flag4) {
    if (flag1 == flag2 && flag3 == flag4)
      return " ";
    return "*";
  }

  private static String tf(boolean flag) {
    if (flag)
      return "T";
    return "F";
  }

  private static String format(double x, int numPlaces, int totalSize) {
    String s;
    NumberFormat nf = NumberFormat.getInstance();
    nf.setMaximumFractionDigits(numPlaces);
    nf.setMinimumFractionDigits(numPlaces);
    s = nf.format(x);
    while (s.length() < totalSize)
      s = " " + s;
    return s;
  }

  private static String leftJustify(String s, int totalSize) {
    while (s.length() < totalSize)
      s = s + " ";
    return s;
  }

}
