package project3;

import java.util.*;
import java.text.*;

public class StringAndDoubleList {

  private ArrayList<StringAndDouble> list;
  private String name;
  private Comparator nameComparator = new StringAndDoubleStringComparator();
  private Comparator valueComparator = new StringAndDoubleDoubleComparator();
  private DecimalFormat df;

  public StringAndDoubleList(String name) {
    this.name = name;
    list = new ArrayList<StringAndDouble> ();
    df = new DecimalFormat("0.00");
  }

  public void addEntry(String s, double value) {
    list.add(new StringAndDouble(s, value));
  }

  public double getValueByString(String s) {
    for (StringAndDouble sd : list)
      if (sd.str.equals(s))
        return sd.value;
    return 0;
  }

  public String getListByString() {
    StringAndDouble[] sortedList;
    sortedList = sortByString();
    return getListFromArray(sortedList);
  }

  private String getListFromArray(StringAndDouble[] array) {
    StringBuffer sb;
    int longestName = 1;
    int longestCost = 1;
    int costLength;
    sb = new StringBuffer();
    for (int i = 0; i < array.length; i++) {
      if (array[i].str.length() > longestName)
        longestName = array[i].str.length();
      costLength = df.format(array[i].value).length();
      if (costLength > longestCost)
        longestCost = costLength;
    }
    for (int i = 0; i < array.length; i++)
      sb.append(rightPad(array[i].str + ":", longestName + 3) +
                leftPad(df.format(array[i].value), longestCost) + "\n");
    return sb.toString();
  }

  private String rightPad(String s, int len) {
    while (s.length() < len)
      s = s + " ";
    return s;
  }

  private String leftPad(String s, int len) {
    while (s.length() < len)
      s = " " + s;
    return s;
  }

    private StringAndDouble[] sortByString() {
      StringAndDouble[] sortedList = new StringAndDouble[list.size()];
      for (int i = 0; i < list.size(); i++)
        sortedList[i] = list.get(i);
      Arrays.sort(sortedList, nameComparator);
      return sortedList;
    }

/*
  private StringAndDouble[] sortByString() {
    StringAndDouble[] sortedList = new StringAndDouble[list.size()];
    for (int i = 0; i < list.size(); i++)
      sortedList[i] = list.get(i);
    Arrays.sort(sortedList, new Comparator<StringAndDouble> () {
      public int compare(StringAndDouble sd1, StringAndDouble sd2) {
        return sd1.str.compareTo(sd2.str);
      }
    });
    return sortedList;
  }
 */

    private StringAndDouble[] sortByValue() {
      StringAndDouble[] sortedList = new StringAndDouble[list.size()];
      for (int i = 0; i < list.size(); i++)
        sortedList[i] = list.get(i);
      Arrays.sort(sortedList, valueComparator);
      return sortedList;
    }

/*
  private StringAndDouble[] sortByValue() {
    StringAndDouble[] sortedList = new StringAndDouble[list.size()];
    for (int i = 0; i < list.size(); i++)
      sortedList[i] = list.get(i);
    Arrays.sort(sortedList, new Comparator<StringAndDouble> () {
      public int compare(StringAndDouble sd1, StringAndDouble sd2) {
        if (sd1.value == sd2.value)
          return 0;
        if (sd1.value > sd2.value)
          return 1;
        return -1;
      }
    });
    return sortedList;
  }
*/

  public String getListByValue() {
    StringAndDouble[] sortedList;
    sortedList = sortByValue();
    Arrays.sort(sortedList, valueComparator);
    return getListFromArray(sortedList);
  }

  public String getFullName(String partialName) {
    for (StringAndDouble sd: list)
      if (sd.str.startsWith(partialName))
        return sd.str;
    return null;
  }

  public String toString() {
    return "Number of entries in " + name + " is " + list.size();
  }

}
