package project3;

import java.text.*;

public class TennisRacket {
  private String name;
  private double cost;
  private String stringName;
  private double stringCost;
  private String gripSize;
  private double shippingCost;
  private double taxRate;
  private DecimalFormat df = new DecimalFormat("0.00");

  public TennisRacket(String name, double cost, String stringName, double stringCost, String gripSize, double shippingCost, double taxRate) {
    this.name = name;
    this.cost = cost;
    this.stringName = stringName;
    this.stringCost = stringCost;
    this.gripSize = gripSize;
    this.shippingCost = shippingCost;
    this.taxRate = taxRate;
  }

  public String getInvoice() {
    double totalCost;
    String headerString;
    String firstInvoiceLine;
    String s;
    firstInvoiceLine = invoiceLine("Racket: "+name,cost);
    headerString = makeConstantString('-',firstInvoiceLine.length());
    s = headerString + firstInvoiceLine;

    s = s + invoiceLine("String: "+stringName,stringCost);
    s = s + invoiceLine("Gripsize: "+gripSize,0);
    s = s + invoiceLine("Shipping: ",shippingCost);
    totalCost = cost + stringCost + shippingCost;
    totalCost = totalCost*(1 + taxRate);
    s = s + invoiceLine("Total:",totalCost);
    s = s + headerString;
    return s;
  }

  private String makeConstantString(char c, int n) {
    String s = "";
    while (s.length() < n)
      s = s + c;
    return s + "\n";
  }

  private String invoiceLine(String name, double cost) {
    int rightPad = 40;
    int leftPad = 10;
    return padRight(name,rightPad) + padLeft(cost,leftPad) + "\n";
  }

  private String padRight(String s, int n) {
    while (s.length() < n)
      s = s + " ";
    return s;
  }

  private String padLeft(double c, int n) {
    String s = df.format(c);
    while (s.length() < n)
      s = " " + s;
    return s;
  }

}
