package project3;

public class TennisRacketDatabase {

  private static StringAndDoubleList rackets = new StringAndDoubleList("rackets");
  private static StringAndDoubleList strings = new StringAndDoubleList("strings");
  private static double nextDayShipping = 0.0;
  private static double secondDayShipping = 0.0;
  private static double groundShipping = 0.0;
  private static double taxRate = 0.0;

  public static void setShipping(double next, double second, double ground) {
    nextDayShipping = next;
    secondDayShipping = second;
    groundShipping = ground;
  }

  public static void setTaxRate(double rate) {
    taxRate = rate;
  }

  public static double getTaxRate(String state) {
    if (state.equals("Texas"))
      return taxRate;
    return 0.0;
  }

  public static double getShipping(int days) {
    if (days == 1)
      return nextDayShipping;
    else if (days == 2)
      return secondDayShipping;
    else
      return groundShipping;
  }

  public static String getRacketListByName() {
    return rackets.getListByString();
  }

  public static String getRacketListByCost() {
    return rackets.getListByValue();
  }

  public static String getStringListByName() {
    return strings.getListByString();
  }

  public static String getStringListByCost() {
    return strings.getListByValue();
  }

  public static void addRacket(String name, double cost) {
    rackets.addEntry(name,cost);
  }

  public static void addString(String name, double cost) {
    strings.addEntry(name,cost);
  }

  public static double getRacketCost(String name) {
    return rackets.getValueByString(name);
  }

  public static double getStringCost(String name) {
    return strings.getValueByString(name);
  }

  public static String getRacketFullName(String partialName) {
    return rackets.getFullName(partialName);
  }

  public static String getStringFullName(String partialName) {
    return strings.getFullName(partialName);
  }



}
