package rectangle;

public class Rectangle {

  private double width;
  private double length;
  private double area;

  public Rectangle(int w, int l) {
    width = w;
    length = l;
    area = length*width;
  }

  public double getWidth() {
    return width;
  }

  public double getLength() {
    return length;
  }

  public double getArea() {
    return area;
  }

  public double getPerimeter() {
    return 2*length + 2*width;
  }

  public double getDiagonal() {
    return Math.sqrt(width*width + length*length);
  }

  public void setWidth(double w) {
    width = w;
    area = length*width;
  }

  public String toString() {
    return "Rectangle with width " + width + " and length " + length;
  }

}
