/* Account class from Week 4.
   Include first two modifications but not the overdraft option.
*/


public class Account {
  private String name;
  private String accountNumber;
  private double beginningBalance; // beginning monthly balance
  private double currentBalance;
  private double monthlyDeposits;
  private double monthlyWithdrawals;
  private int numberOfMonthlyDeposits;
  private int numberOfMonthlyWithdrawals;

  public Account(String myName, String myAccountNumber,
                 double myBeginningBalance) {
    name = myName;
    accountNumber = myAccountNumber;
    beginningBalance = myBeginningBalance;
    currentBalance = beginningBalance;
    monthlyDeposits = 0;
    monthlyWithdrawals = 0;
    numberOfMonthlyDeposits = 0;
    numberOfMonthlyWithdrawals = 0;
  }

  public String getName() {
    return name;
  }

  public String getAccountNumber() {
    return accountNumber;
  }

  public double getBeginningBalance() {
    return beginningBalance;
  }

  public double getCurrentBalance() {
    return currentBalance;
  }

  public double getMonthlyDeposits() {
    return monthlyDeposits;
  }

  public double getMonthlyWIthdrawals() {
    return monthlyWithdrawals;
  }

  public int getNumberOfMonthlyDeposits() {
    return numberOfMonthlyDeposits;
  }

  public int getNumberOfMonthlyWithdrawals() {
    return numberOfMonthlyWithdrawals;
  }

  public void makeDeposit(double amount) {
    monthlyDeposits += amount;
    currentBalance += amount;
    numberOfMonthlyDeposits++;
  }

  // return true on success and false on failure
  public boolean makeWithdrawal(double amount) {
    if (amount <= currentBalance) {
      monthlyWithdrawals += amount;
      currentBalance -= amount;
      numberOfMonthlyWithdrawals++;
      return true;
    }
    return false;
  }

  // sets monthly deposits and withsrawals to zero
  public void initializeMonth() {
    monthlyDeposits = 0;
    monthlyWithdrawals = 0;
    beginningBalance = currentBalance;
    numberOfMonthlyDeposits = 0;
    numberOfMonthlyWithdrawals = 0;
  }

  public String toString() {
    return "Account Name: " + name +
        "\n  Account Number: " + accountNumber +
        "\n  Beginning Balance: " + beginningBalance +
        "\n  Current Balance: " + currentBalance +
        "\n  Monthly Deposits: " + monthlyDeposits +
        " (" + numberOfMonthlyDeposits + ")" +
        "\n  Monthly Withdrawals: " + monthlyWithdrawals +
        " (" + numberOfMonthlyWithdrawals + ")";
  }
}
