package rational;

public class RationalNumber {
   private int numerator;
   private int denominator;

   public RationalNumber(int numer, int denom) {
      if (denom == 0) // handle 0 denominator
         denom = 1;
      if (denom < 0) { // Make the numerator "store" the sign
         numer = numer * -1;
         denom = denom * -1;
      }
      numerator = numer;
      denominator = denom;
      reduce();
   }

   public int getNumerator() {
      return numerator;
   }

   public int getDenominator() {
      return denominator;
   }

   public RationalNumber reciprocal() {
      return new RationalNumber(denominator, numerator);
   }

   public RationalNumber add(RationalNumber op2) {
      int a, b, c, d;
      a = numerator;
      b = denominator;
      c = op2.getNumerator();
      d = op2.getDenominator();
      return new RationalNumber(a * d + b * c, b * d);
   }

   public RationalNumber subtract(RationalNumber op2) {
      return null;
   }

   public RationalNumber multiply(RationalNumber op2) {
      return new RationalNumber(numerator * op2.getNumerator(),
                                denominator * op2.getDenominator());
   }

   public RationalNumber divide(RationalNumber op2) {
      return null;
   }

   public boolean equals(RationalNumber op2) {
      return numerator == op2.getNumerator() &&
            denominator == op2.getDenominator();
   }

   public String toString() {
      if (numerator == 0)
         return "0";
      else if (denominator == 1)
         return numerator + "";
      else
         return numerator + "/" + denominator;
   }

   private void reduce() { // divide numerator and denominator by gcd to reduce
      if (numerator != 0) {
         int common = gcd(Math.abs(numerator), denominator);
         numerator = numerator / common;
         denominator = denominator / common;
      }
      else
         denominator = 1;
   }

   private int gcd(int num1, int num2) { // return greatest common divisor
      while (num1 != num2)
         if (num1 > num2)
            num1 = num1 - num2;
         else
            num2 = num2 - num1;
      return num1;
   }
}
