package arrays;

public class ArrayUtility {

  public static void printArray(int[] array) {
     for (int k = 0; k < array.length; k++)
         System.out.print(array[k] + " ");
     System.out.println();
  }

  public static void printBackwards(int[] array) {
      for (int k = array.length - 1; k >= 0; k--)
          System.out.print(array[k] + " ");
      System.out.println();
   }

   public static int getSum(int [] array) {
     int sum = 0;
     for (int k = 0; k < array.length; k++)
         sum += array[k];
     return sum;
   }

   public static double getAverage(int [] array) {
     if (array.length == 0)
       return 0.0;
     return getSum(array)/(double)array.length;
   }

   public static int getMax(int [] array) {
     if (array.length == 0)
       return Integer.MIN_VALUE;
     int max = array[0];
     for (int k = 1; k < array.length; k++)
       if (max < array[k])
         max = array[k];
     return max;
   }

}
