package arrayclasses;

public class ClassList {
  private String title;
  private String discipline;
  private int number;
  private String instructor;
  private String semester;
  private StudentGrade[] students;
  private int numStudents;
  private int maxCapacity = 33;

  public ClassList(String title, String discipline, int number,
                   String instructor, String semester) {
    this.title = title;
    this.discipline = discipline;
    this.number = number;
    this.instructor = instructor;
    this.semester = semester;
    students = new StudentGrade[maxCapacity];
    numStudents = 0;
  }

  public void addStudent(String studentId) {
    students[numStudents] = new StudentGrade(studentId, 0.0);
    numStudents++;
  }

  public String toString() {
    String s;
    s = "Class: " + title + ", " + discipline + " " + number +
        ", instructor: " + instructor + ", " + semester;
    for (int i=0; i<numStudents;i++)
      s = s + "\n   "+students[i];
    return s;

  }

}
