package arrayclasses;

public class ClassList {
  private String title;
  private String discipline;
  private int number;
  private String instructor;
  private String semester;
  private StudentGrade[] students;
  private int numStudents;
  private int maxCapacity = 5;

  public ClassList(String title, String discipline, int number,
                   String instructor, String semester) {
    this.title = title;
    this.discipline = discipline;
    this.number = number;
    this.instructor = instructor;
    this.semester = semester;
    students = new StudentGrade[maxCapacity];
    numStudents = 0;
  }

// return true on success and false on failure
  public boolean addStudent(String studentId) {
    if (numStudents == maxCapacity)
      return false;
    students[numStudents] = new StudentGrade(studentId, 0.0);
    numStudents++;
    return true;
  }

  // returns true on success and false on failure
  public boolean setGrade(String studentID, double grade) {
    for (int i=0; i<numStudents;i++)
      if (students[i].getStudentID().equals(studentID)) {
        students[i].setGrade(grade);
        return true;
      }
    return false;
  }

  // return -1 if not found
  public double findGrade(String studentID) {
    for (int i=0; i<numStudents;i++)
      if (students[i].getStudentID().equals(studentID))
        return students[i].getGrade();
    return -1;
  }

  public String toString() {
    String s;
    s = "Class: " + title + ", " + discipline + " " + number +
        ", instructor: " + instructor + ", " + semester;
    for (int i=0; i<numStudents;i++)
      s = s + "\n   "+students[i];
    return s;

  }

}
