package tictactoe;

public class TicTacToe {
  private char[][] board;
  private char nextPlayer;
  private int boardsize;


  public TicTacToe(int boardsize) {
    this.boardsize = boardsize;
    nextPlayer = 'X';
    board = new char[boardsize][boardsize];
    for (int i=0;i<boardsize;i++)
      for (int j=0;j<boardsize;j++)
        board[i][j] = ' ';
  }

  public boolean move(int x, int y) {
    board[x][y] = nextPlayer;
    if (nextPlayer == 'X')
      nextPlayer = 'O';
    else
      nextPlayer = 'X';
    return true;
  }


  public String toString() {
    String s;
    s = "boardsize is "+boardsize +" by " + boardsize+ "\n";
    s = s + "next player is "+nextPlayer + "\n";
    for (int i=0;i<boardsize;i++) {
      for (int j=0;j<boardsize;j++)  {
        s = s + " "+board[i][j]+" ";
        if (j < boardsize - 1)
          s = s + "|";
      }
      s = s + "\n";
      if (i < boardsize -1) {
        for (int j = 0; j < boardsize; j++) {
          s = s + "---";
          if (j < boardsize - 1)
          s = s + "|";
        }
        s = s + "\n";
      }
    }
    return s;
  }


}
