package tictactoe;

public class TicTacToe {
  private char[][] board;
  private char nextPlayer;
  private int boardsize;
  private int movesMade;

  public TicTacToe(int boardsize) {
    this.boardsize = boardsize;
    nextPlayer = 'X';
    movesMade = 0;
    board = new char[boardsize][boardsize];
    for (int i = 0; i < boardsize; i++)
      for (int j = 0; j < boardsize; j++)
        board[i][j] = ' ';
  }

// return true if successful, false otherwise
  public boolean move(int x, int y) {
    if ( (x < 0) || (y < 0))
      return false;
    if ( (x > boardsize - 1) || (y > boardsize - 1))
      return false;
    if (board[x][y] != ' ')
      return false;
    board[x][y] = nextPlayer;
    movesMade++;
    if (nextPlayer == 'X')
      nextPlayer = 'O';
    else
      nextPlayer = 'X';
    return true;
  }

  // return X, O, D or blank
  public char getWinner() {
    // return X or O if winner
    if (wonRow('X'))
      return 'X';
    // return D if draw
    if (movesMade == boardsize * boardsize)
      return 'D';
    // return blank otherwise
    return ' ';
  }

  private boolean wonRow(char c) {
    for (int i = 0; i < boardsize; i++)
      if (wonRow(c, i))
        return true;
    return false;
  }

  private boolean wonRow(char c, int n) {
    for (int i = 0; i < boardsize; i++)
      if (board[n][i] != c)
        return false;
    return true;
  }

  public String toString() {
    String s;
    s = "boardsize is " + boardsize + " by " + boardsize + "\n";
    s = s + "next player is " + nextPlayer + "\n";
    for (int i = 0; i < boardsize; i++) {
      for (int j = 0; j < boardsize; j++) {
        s = s + " " + board[i][j] + " ";
        if (j < boardsize - 1)
          s = s + "|";
      }
      s = s + "\n";
      if (i < boardsize - 1) {
        for (int j = 0; j < boardsize; j++) {
          s = s + "---";
          if (j < boardsize - 1)
            s = s + "|";
        }
        s = s + "\n";
      }
    }
    return s;
  }

}
