package sorts;

public class QuadraticSort {


  public static void selectionSort(Comparable [] list) {
     for (int index = 0; index < list.length - 1; index++) {
         int min = findMinPosition(list, index);
         Comparable temp = list[min];
         list[min] = list[index];
         list[index] = temp;
     }
  }

  public static int findMinPosition(Comparable [] list, int start) {
     int min = start;
     for (int scan = start + 1; scan < list.length; scan++)
        if (list[min].compareTo(list[scan]) > 0 )
           min = scan;
     return min;
  }


  public static void selectionSort(int [] list) {
      for (int index = 0; index < list.length - 1; index++) {
          int min = findMinPosition(list, index);
          int temp = list[min];
          list[min] = list[index];
          list[index] = temp;
      }
   }

   public static int findMinPosition(int [] list, int start) {
      int min = start;
      for (int scan = start + 1; scan < list.length; scan++)
         if (list[min] > list[scan])
            min = scan;
      return min;
   }

   public static void insertionSort (Comparable [] list) {
       for (int index = 1; index < list.length; index++) {
          insertItem(list, index);
       }
    }

    public static void insertItem(Comparable [] list, int index) {
        Comparable key = list[index];
        int position = index;

          // shift larger values to the right
        while (position > 0 && key.compareTo(list[position-1]) < 0)   {
           list[position] = list[position-1];
           position--;
        }
        list[position] = key;
     }




}
