package sorts;

public class Search {
  public static int linearSearch(int [] list, int val){
        for (int i = 0; i < list.length; i++)
            if (list[i] == val)
               return i;
        return -1;
    }

    public static int linearSearch(Comparable [] list, Comparable val){
      for (int i = 0; i < list.length; i++)
         if (list[i].compareTo(val) == 0)
            return i;
      return -1;
  }

  public static int binarySearch(int [] list, int value) {
     int low = 0;
     int high = list.length - 1;
     while (low <= high) {
        int mid = (low + high)/2;
        if (list[mid] == value)
           return mid;
        else if (list[mid] < value)
           low = mid + 1;
        else
           high = mid - 1;
     }
     return -1;
  }


}
