package sorts;

import java.util.*;

public class SearchTest {

  private static final double BILLION = 1000000000.0;

  public static void main(String[] args) {
    long startTime;
    long endTime;
    System.out.println("This program was written by S. Robbins");

    int[] array = generateRandomArray(400000);
    int[] array1 = new int[array.length];
    int[] array2 = new int[array.length];
    for (int i = 0; i < array.length; i++) {
      array1[i] = array[i];
       array2[i] = array[i];
    }
    printArray(array, "This is the array");
    printArray(array1, "This is the other array");

    startTime = System.nanoTime();
       Arrays.sort(array2);
       endTime = System.nanoTime();
       printArray(array1, "This is the sorted array");
       System.out.println("The time to do the java sort is " +
                       (endTime - startTime) / BILLION + " seconds");
    startTime = System.nanoTime();
    QuadraticSort.selectionSort(array);
    endTime = System.nanoTime();
    printArray(array, "This is the sorted array");
    System.out.println("The time to do the selection sort is " +
                       (endTime - startTime) / BILLION + " seconds");

    startTime = System.nanoTime();
    QuadraticSort.insertionSort(array1);
    endTime = System.nanoTime();
    printArray(array1, "This is the sorted array");
    System.out.println("The time to do the insertion sort is " +
                       (endTime - startTime) / BILLION + " seconds");


  }

  public static int[] generateRandomArray(int n) {
    int[] array = new int[n];
    Random rand = new Random();
    for (int i = 0; i < n; i++)
      array[i] = rand.nextInt(100);
    return array;
  }

  public static void printArray(int[] list, String msg) {
    if (list.length > 50)
      return;
    System.out.print("\n" + msg + ":\n[");
    for (int i = 0; i < list.length; i++)
      System.out.print(" " + list[i]);
    System.out.println(" ]");
  }

}
