package tictactoe;

public class TicTacToe {
  private char[][] board;
  private char nextPlayer;
  private int boardsize;
  private int movesMade;
  private TicTacToeUI userX;
  private TicTacToeUI userO;

  public TicTacToe(int boardsize) {
    this.boardsize = boardsize;
    nextPlayer = 'X';
    movesMade = 0;
    board = new char[boardsize][boardsize];
    for (int i = 0; i < boardsize; i++)
      for (int j = 0; j < boardsize; j++)
        board[i][j] = ' ';
  }

  public void setUserInterfaceX(TicTacToeUI user) {
    this.userX = user;
    userX.update(board);
  }

  public void setUserInterfaceO(TicTacToeUI user) {
    this.userO = user;
    userO.update(board);
  }

// return true if successful, false otherwise
  public boolean move(int x, int y, TicTacToeUI user) {
    char winner;
    TicTacToeUI otherUser;
    if ( ( (nextPlayer == 'X') && (user != userX)) ||
        ( (nextPlayer == 'O') && (user != userO))) {
      user.displayMessage("It is not your turn");
      user.update(board);
      return false;
    }
    if ( (x < 0) || (y < 0)) {
      user.displayMessage("Something was less than 0");
      user.update(board);
      return false;
    }
    if ( (x > boardsize - 1) || (y > boardsize - 1)) {
      user.displayMessage("Entry was too large");
      user.update(board);
      return false;
    }
    if (board[x][y] != ' ') {
      user.displayMessage("Move already made, try again");
      user.update(board);
      return false;
    }
    if (user == userX)
      otherUser = userO;
    else
      otherUser = userX;
    board[x][y] = nextPlayer;
    movesMade++;
    if (nextPlayer == 'X')
      nextPlayer = 'O';
    else
      nextPlayer = 'X';
    winner = getWinner();
    if (winner == ' ') {
      user.displayMessage("Waiting for other player ...");
      otherUser.displayMessage("Enter a Move");
      user.setTurn(false);
      otherUser.setTurn(true);
    }
    else {
      if (winner == 'D') {
        user.displayMessage("Game is a draw");
        otherUser.displayMessage("Game is a draw");
      }
      else {
        user.displayMessage("You won!");
        otherUser.displayMessage("You lost!");
      }
      user.setGameOver();
       otherUser.setGameOver();
    }
    user.update(board);
    otherUser.update(board);
    return true;
  }

  // return X, O, D or blank
  public char getWinner() {
    // return X or O if winner
    if (wonRow('X') || wonCol('X') || wonDiag1('X') || wonDiag2('X'))
      return 'X';
    if (wonRow('O') || wonCol('O') || wonDiag1('O') || wonDiag2('O'))
      return 'O';
    // return D if draw
    if (movesMade == boardsize * boardsize)
      return 'D';
    // return blank otherwise
    return ' ';
  }

// return true if c fills a row
  private boolean wonRow(char c) {
    for (int i = 0; i < boardsize; i++)
      if (wonRow(c, i))
        return true;
    return false;
  }

// return true if c fills row n
  private boolean wonRow(char c, int n) {
    for (int i = 0; i < boardsize; i++)
      if (board[n][i] != c)
        return false;
    return true;
  }

// return true if c fill a column
  private boolean wonCol(char c) {
    for (int i = 0; i < boardsize; i++)
      if (wonCol(c, i))
        return true;
    return false;
  }

// return true if c fills column n
  private boolean wonCol(char c, int n) {
    for (int i = 0; i < boardsize; i++)
      if (board[i][n] != c)
        return false;
    return true;
  }

// return true if c fills the major diagonal
  private boolean wonDiag1(char c) {
    for (int i = 0; i < boardsize; i++)
      if (board[i][i] != c)
        return false;
    return true;
  }

// return true if c fills the minor diagonal
  private boolean wonDiag2(char c) {
    for (int i = 0; i < boardsize; i++)
      if (board[i][boardsize - i - 1] != c)
        return false;
    return true;
  }

// return a string representing the board
  public String toString() {
    String s;
    char winner;
    s = "boardsize is " + boardsize + " by " + boardsize + "\n";
    winner = getWinner();
    if ( (winner == 'X') || (winner == 'O'))
      s = s + winner + " won!\n";
    else if (winner == 'D')
      s = s + "game is a draw\n";
    else
      s = s + "next player is " + nextPlayer + "\n";

    for (int i = 0; i < boardsize; i++) {
      for (int j = 0; j < boardsize; j++) {
        s = s + " " + board[i][j] + " ";
        if (j < boardsize - 1)
          s = s + "|";
      }
      s = s + "\n";
      if (i < boardsize - 1) {
        for (int j = 0; j < boardsize; j++) {
          s = s + "---";
          if (j < boardsize - 1)
            s = s + "|";
        }
        s = s + "\n";
      }
    }
    return s;
  }

}
