package tictactoe;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class TicTacToeGUI
    implements TicTacToeUI {

  private TicTacToe game;
  private JLabel messageLabel;
  private JButton[][] buttons;
  private boolean running = false;
  private char me = ' ';
  private boolean myTurn = false;
  private TicTacToeUI myUI;

  public TicTacToeGUI(TicTacToe game) {
    this.game = game;
    JFrame telephone = new JFrame("Tic Tac Toe");
    telephone.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    telephone.getContentPane().add(new TicTacToePanel());
    telephone.pack();
    telephone.setVisible(true);
    myUI = this;
  }

  public void setChar(char c) {
    me = c;
  }

  public void setTurn(boolean f) {
    myTurn = f;
  }

  public void setGameOver() {
    running = false;
  }

  public void play() {
    running = true;
  }

  public void displayMessage(String s) {
    messageLabel.setText(s);
  }

  public void update(char[][] board) {
    for (int i = 0; i < board.length; i++)
      for (int j = 0; j < board.length; j++)
        buttons[i][j].setText("" + board[i][j]);
  }

  private class TicTacToePanel
      extends JPanel {

    public TicTacToePanel() {
      setLayout(new BorderLayout());
      messageLabel = new JLabel("Starting out");
      add(messageLabel, BorderLayout.SOUTH);
      JPanel buttonPanel = new JPanel();
      buttonPanel.setLayout(new GridLayout(3, 3));
      buttons = new JButton[3][3];
      for (int i = 0; i < 3; i++)
        for (int j = 0; j < 3; j++) {
          buttons[i][j] = new JButton("????");
          buttonPanel.add(buttons[i][j]);
          buttons[i][j].addActionListener(new ButtonListener(i, j));
        }
      add(buttonPanel, BorderLayout.CENTER);

    }

  }

  private class ButtonListener
      implements ActionListener {
    int row;
    int col;

    public ButtonListener(int row, int col) {
      this.row = row;
      this.col = col;
    }

    public void actionPerformed(ActionEvent event) {
      if (running)
        game.move(row, col,myUI);
    }
  }

}
