package tictactoe;

import java.util.Scanner;

public class UserInterface implements TicTacToeUI {

  private TicTacToe game;
  private boolean running;
  private char me;
  private boolean myTurn;

  public UserInterface(TicTacToe game) {
    this.game = game;
  }

  public void setGameOver() {
    running = false;
  }

  public void setChar(char c) {
  me = c;
}

public void setTurn(boolean f) {
  myTurn = f;
}


  public void play() {
    Scanner scan = new Scanner(System.in);
    int row;
    int col;
    running = true;
    while (running) {
      row = scan.nextInt();
      col = scan.nextInt();
      game.move(row, col,this);
    }
  }

  public void displayMessage(String s) {
    System.out.println(s);
  }

  public void update(char[][] board) {
    String s;
    int boardsize = board.length;
    s = "";

    for (int i = 0; i < boardsize; i++) {
      for (int j = 0; j < boardsize; j++) {
        s = s + " " + board[i][j] + " ";
        if (j < boardsize - 1)
          s = s + "|";
      }
      s = s + "\n";
      if (i < boardsize - 1) {
        for (int j = 0; j < boardsize; j++) {
          s = s + "---";
          if (j < boardsize - 1)
            s = s + "|";
        }
        s = s + "\n";
      }
    }
    System.out.println(s);
  }

}
