/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class Sender
implements Runnable {
    private boolean debug = false;
    private Socket sock;
    private DataInputStream in;
    private DataOutputStream out;
    private InfoFrame info;
    private byte[] user = null;

    private Sender(Socket sock, DataInputStream in, DataOutputStream out, String userName, InfoFrame info) {
        this.sock = sock;
        this.in = in;
        this.out = out;
        this.info = info;
        this.setUser(userName);
    }

    public void run() {
        this.signin();
    }

    public void signin() {
        this.debugOut("In signin in sender, user is " + new String(this.user));
        byte[] buffer = new byte[100];
        if (this.user == null) {
            return;
        }
        try {
            this.out.write(this.user);
            this.debugOut("Write done");
            this.out.flush();
            this.debugOut("Flush done");
            this.info.setOnlyLabel2(" Waiting for response from server ...");
            this.info.setButtonQuit();
            this.debugOut("Waiting for response from server");
            int numRead = this.in.read(buffer);
            this.debugOut("Got response " + numRead);
            if (numRead > 0) {
                this.info.setLabel2(" " + new String(buffer, 0, numRead));
                this.info.setButtonDone();
            } else {
                this.info.setLabel2(" Sign in failed!");
                this.info.setButtonQuit();
            }
            this.sock.close();
            this.debugOut("Close done");
        }
        catch (IOException e) {
            this.debugOut("Write failed");
            this.info.setOnlyLabel2(" Failed writing to server");
            this.info.setButtonQuit();
        }
    }

    private void setUser(String s) {
        String localHost = "unknown";
        try {
            localHost = InetAddress.getLocalHost().toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        s = s + " on " + localHost;
        this.user = new byte[s.length() + 1];
        for (int i = 0; i < s.length(); ++i) {
            this.user[i] = (byte)s.charAt(i);
        }
        this.user[this.user.length - 1] = 10;
    }

    public static Sender make(String host, int port, String userName, InfoFrame info) {
        DataOutputStream out;
        DataInputStream in;
        Socket sock;
        try {
            sock = new Socket(host, port);
            in = new DataInputStream(sock.getInputStream());
            out = new DataOutputStream(sock.getOutputStream());
        }
        catch (Exception e) {
            return null;
        }
        return new Sender(sock, in, out, userName, info);
    }

    private void debugOut(String s) {
        if (this.debug) {
            System.out.println(s);
        }
    }
}

