package tictactoe;

public class Game implements GameInterface {

  private int boardSize;
  private UserInterface userX = null;
  private UserInterface userO = null;
  private char winner;
  private char[][] board;
  private UserInterface playerToMove;


  public Game(int boardSize) {
    this.boardSize = boardSize;
    board = new char[boardSize][boardSize];
    for (int i=0;i<boardSize;i++)
      for (int j=0;j<boardSize;j++)
        board[i][j] = ' ';
  }

  public int getBoardSize() {
    return boardSize;
  }


  /*
  if the move is valid:
      update the board
      display board for both users
      if game not over
         prompt next user to make a move
      otherwise
         notify both users
   if the move is invalid:
      display the board for both users
      prompt same user for move

  */
  public void move(int row, int column, UserInterface user){
     if (user != playerToMove)
       return;
     if (board[row][column] != ' ') {
       user.promptForMove();
       return;
     }
     if (user == userX) {
       board[row][column] = 'X';
       playerToMove = userO;
     }
     else {
       board[row][column] = 'O';
       playerToMove = userX;
     }
     userX.displayBoard(board);
     userO.displayBoard(board);
     if (checkGameOver()) {
       userX.gameOver(winner);
       userO.gameOver(winner);
     }
     else
       playerToMove.promptForMove();
  }

  private boolean checkGameOver() {
    return false;
  }

  public void join(UserInterface user) {
     if (userX == null) {
       userX = user;
       playerToMove = userX;
     }
     else if (userO == null)
       userO = user;
  }

  public void startGame() {
    System.out.println("userX is "+userX);
      userX.displayBoard(board);
      userO.displayBoard(board);
      userX.promptForMove();
  }


  // return a string that can display the board nicely
// this is a convenience for a text-based interface and for debugging
  public String toString() {
    String s;
    s = "boardsize is " + boardSize + " by " + boardSize + "\n";
    if ( (winner == 'X') || (winner == 'O'))
      s = s + winner + " won!\n";
    else if (winner == 'D')
      s = s + "game is a draw\n";
    else if (playerToMove == null)
      s = s + "game not started yet\n";
//    else
//      s = s + "next player is " + playerToMove.getUserId() + "\n";

    for (int i = 0; i < boardSize; i++) {
      for (int j = 0; j < boardSize; j++) {
        s = s + " " + board[i][j] + " ";
        if (j < boardSize - 1)
          s = s + "|";
      }
      s = s + "\n";
      if (i < boardSize - 1) {
        for (int j = 0; j < boardSize; j++) {
          s = s + "---";
          if (j < boardSize - 1)
            s = s + "|";
        }
        s = s + "\n";
      }
    }
    return s;
  }

}
